/*****************************
	Weather 5.0
	Maxthon Sidebar Plugin
	By Neo101
******************************/

var SECURITY_ID	= max_security_id
var PLUGIN_NAME = "Weather5"

var alreadyShowingError	= false
window.onerror	= showErrorMessage

var SETTINGS_FILE = 'settings.ini'
var DEFAULT_SETTINGS_FILE = 'DefaultSettings.ini'
var DEFAULT_LANGUAGE_FILE = 'Language.ini'
var LANGUAGE_DIRECTORY = 'language/'

var translations = {}

var errorMessages = ''

function showErrorMessage(message, url, line){
	var d 		= new Date()
	var date	= d.getHours()+':'+d.getMinutes()+':'+d.getSeconds()
	if(!alreadyShowingError)
		external.get_tab(SECURITY_ID, external.cur_sel).window.status 
				= 'Message: '+message+' Line: '+line+' URL: '+url+' Date: '+date
	alreadyShowingError	= true
}


function readFile(filename) {
	return external.readFile(SECURITY_ID,PLUGIN_NAME,filename)
}


function writeFile(filename,data) {
	external.writeFile(SECURITY_ID,PLUGIN_NAME,filename,data)
}


function readSetting(Key, errorResponse) {
	if(errorResponse == null) 
		errorResponse = ''
	var returnValue = readIni(SETTINGS_FILE,"Settings", Key, 'error')
	if(returnValue == 'error') {
		var defaultFileValue = readIni(DEFAULT_SETTINGS_FILE,"Settings", Key, 'error')
		if(defaultFileValue == 'error')
			return errorResponse
		else {
			writeSetting(Key, defaultFileValue)
			returnValue = defaultFileValue
		}
	}
	return returnValue
}


function checkSettingsFile(){
	if(readIni("settings.ini","Settings", 'ActiveCity', 'error') != 'error'){
		return false
	}
	var defaultSettingsFile = readFile('DefaultSettings.ini')
	if(defaultSettingsFile && defaultSettingsFile != ''){
		writeFile('Settings.ini', defaultSettingsFile)
		return true
	}
}


function readIni(file, section, key, errorResponse){
	if(errorResponse == null) 
		errorResponse = ''
	return external.m2_readIni(SECURITY_ID, PLUGIN_NAME, file, section, key, errorResponse)
}


function writeIni(file, section, key, data) {
	external.m2_writeIni(SECURITY_ID, PLUGIN_NAME, file, section, key, data+'')
}


function writeSetting(key, data) {
	writeIni(SETTINGS_FILE,"Settings", key, data+'')
}


function translate(word, abbreviation, section, noWT) {
	
	if(translations[word] != null && abbreviation == null){
		return translations[word]
	}

	if(section == null){
		section = defaultSection
	}
	if(noWT != null){
		var iniWord = word
	}
	else {
		var iniWord = 'WT_'+word
	}
	
		
	var translation = readIni(LANGUAGE_DIRECTORY + "Language"+languageID+".ini", section, iniWord, 'err')
	if(section == 'WeatherTypes'){
		if(translation == 'err'){
			translation = readIni(LANGUAGE_DIRECTORY + "Language"+languageID+".ini", section, iniWord.replace(/ ?\/ ?/g,'/'), 'err')
		}
		if(translation == 'err'){
			translation = readIni(LANGUAGE_DIRECTORY + "Language"+languageID+".ini", section, iniWord.replace(/ ?\/ ?/g,'/ '), 'err')
		}
		if(translation == 'err'){
			translation = readIni(LANGUAGE_DIRECTORY + "Language"+languageID+".ini", section, iniWord.replace(/ ?\/ ?/g,' /'), 'err')
		}
		if(translation == 'err'){
			translation = readIni(LANGUAGE_DIRECTORY + "Language"+languageID+".ini", section, iniWord.replace(/ ?\/ ?/g,' / '), 'err')
		}
	}
	if(translation == 'err'){ 
		translation = readIni(LANGUAGE_DIRECTORY + DEFAULT_LANGUAGE_FILE, section, iniWord, 'err')
	}
	if(translation == 'err'){
		translation = word
	}
	if(abbreviation != null){
		if(translation.match(/\|/g) && translation.match(/\|/g).length == 2)
			translation = translation.match(/\|.*?\|/)[0]
		else
			translation = translation.replace(/\|.*/,'')
	}
	
	translation = translation.replace(/\|/g,'')
	
	if(abbreviation == null)
		translations[word] = translation
	
	return translation
}


function writeTrans(word){
	document.write( translate(word) )
}


function showError(message){
	if(document.getElementById('error'))
		document.getElementById('error').innerHTML = message
	else
		errorMessages += message + '\n'
}

/* Translate the cities+countries */

function transLocation(location){
	try{
		var country			= location.split(',')[1].replace(/^ /,'')
		var countryTransl	= translate(country, null, 'Locations', true)
		var city			= location.split(',')[0].replace(/^ /,'')
		var cityTransl		= translate(city, null, 'Locations', true)
		if(countryTransl !='' && countryTransl != country) 
			location = location.replace(country,' '+countryTransl)
		if(cityTransl !='' && cityTransl != city) 
			location = location.replace(city,' '+cityTransl)
	}
	catch(err){
		alert(err.description)
	}
	
	return location
}

/* Translate the cities reverse (for the search, in config) */

function transCity(city){
	city = city.toLowerCase()
	var languageFile = readFile(LANGUAGE_DIRECTORY + "Language"+languageID+".ini")
	var cityPart = languageFile.replace(/\r\n/g,'NEWLINE').match(/\[Locations\][^\[]*/i)
	if(cityPart == null)
		return city
	cityPart = cityPart.toString().split('NEWLINE')
	for(var i=0; i<cityPart.length; i++){
		try{
			if(cityPart[i] == '') 
				continue
			var english = cityPart[i].split('=')[0]
			var translation = cityPart[i].split('=')[1].toLowerCase()
			if(translation == city){
				return english
			}
		}
		catch(err){
		}
	}
	return city
}


function translateWind(direction, addSpaces){
	var windDirections = {'N':'North','S':'South','W':'West','E':'East','CALM':'Calm'}
	var windDirShort = ''
	var windDirFull = ''
	if(direction != 'CALM' && direction != 'N/A'){
		var direction = direction.split('')
		for(var i=0; i<direction.length; i++){
			if(direction[i].search(/N|S|W|E/) ==-1)
				continue
			windDirShort += translate( windDirections[ (direction[i]) ] , true)
			windDirFull += translate( windDirections[ (direction[i]) ])
		}
	} else {
		windDirShort = translate( direction )
		windDirFull = windDirShort
	}
	
	if(addSpaces != null){
		if(windDirShort.length == 1)
			windDirShort = '&nbsp;&nbsp;' + windDirShort
		if(windDirShort.length == 2)
			windDirShort = '&nbsp;' + windDirShort
	}
	
	return '<span title='+windDirFull+'>'+windDirShort+'</span>'
}

